/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.parsing;

import com.aptana.core.util.ImmutableTupleN;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.IParseStateCacheKey;
import com.aptana.parsing.ParseStateCacheKey;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.lexer.IRange;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ParseState
implements IParseState {
    private String fSource;
    private int fStartingOffset;
    private IRange[] fSkippedRanges;
    private IProgressMonitor fProgressMonitor;
    private ImmutableTupleN fCacheKey;

    public ParseState(String source) {
        this(source, 0);
    }

    public ParseState(String source, int startingOffset) {
        this(source, startingOffset, null);
    }

    public ParseState(String source, int startingOffset, IRange[] ranges) {
        this.fSource = source != null ? source : "";
        this.fStartingOffset = startingOffset;
        this.fSkippedRanges = ranges;
        this.fCacheKey = this.calculateCacheKey();
    }

    protected ImmutableTupleN calculateCacheKey() {
        int length = this.fSource.length();
        if (length < 11) {
            return new ImmutableTupleN(new Object[]{length, this.fSource, this.fStartingOffset});
        }
        char[] chars = new char[5];
        double factor = (double)length / 4.0;
        chars[0] = this.fSource.charAt(0);
        chars[1] = this.fSource.charAt((int)factor);
        chars[2] = this.fSource.charAt((int)(2.0 * factor));
        chars[3] = this.fSource.charAt((int)(3.0 * factor));
        chars[4] = this.fSource.charAt(length - 1);
        return new ImmutableTupleN(new Object[]{length, this.fSource.hashCode(), new String(chars), this.fStartingOffset});
    }

    public void clearEditState() {
        this.fSource = null;
        this.fSkippedRanges = null;
    }

    public String getSource() {
        return this.fSource;
    }

    public int getStartingOffset() {
        return this.fStartingOffset;
    }

    public void setSkippedRanges(IParseNode[] skippedRanges) {
        this.fSkippedRanges = skippedRanges;
    }

    public IRange[] getSkippedRanges() {
        return this.fSkippedRanges;
    }

    public IProgressMonitor getProgressMonitor() {
        if (this.fProgressMonitor == null) {
            this.fProgressMonitor = new NullProgressMonitor();
        }
        return this.fProgressMonitor;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append('@').append(this.fStartingOffset);
        text.append(':');
        return text.toString();
    }

    public IParseStateCacheKey getCacheKey(String contentTypeId) {
        return new ParseStateCacheKey(contentTypeId, this.fCacheKey);
    }
}

